# Guía de Instalación - BCV Exchange Rates Plugin

## 📋 Requisitos Previos

Antes de instalar el plugin, asegúrate de cumplir con los siguientes requisitos:

### Requisitos del Sistema
- **WordPress**: Versión 5.0 o superior
- **PHP**: Versión 7.2 o superior
- **MySQL**: Versión 5.6 o superior
- **Navegador**: Chrome, Firefox, Safari, Edge (últimas versiones)

### Requisitos de WordPress
- WP-Cron debe estar habilitado
- Permisos de escritura en el directorio de plugins
- Acceso a internet para obtener datos del BCV

## 🚀 Métodos de Instalación

### Método 1: Instalación Directa (Recomendado)

1. **Descargar el plugin**
   - Descarga el archivo `bcv-exchange-rates.zip`
   - No descomprimas el archivo

2. **Subir el plugin**
   - Inicia sesión en tu panel de WordPress
   - Ve a **Plugins > Agregar nuevo**
   - Haz clic en **Subir plugin**
   - Selecciona el archivo ZIP descargado
   - Haz clic en **Instalar ahora**

3. **Activar el plugin**
   - Después de la instalación, haz clic en **Activar plugin**
   - Verás el mensaje "Plugin activado correctamente"

### Método 2: Instalación Manual vía FTP

1. **Preparar los archivos**
   - Descomprime el archivo `bcv-exchange-rates.zip`
   - Deberás tener una carpeta llamada `bcv-exchange-rates`

2. **Subir vía FTP**
   - Conecta a tu servidor mediante FTP
   - Navega a la carpeta `/wp-content/plugins/`
   - Sube la carpeta `bcv-exchange-rates` completa

3. **Activar el plugin**
   - Inicia sesión en WordPress
   - Ve a **Plugins > Plugins instalados**
   - Busca "BCV Exchange Rates"
   - Haz clic en **Activar**

### Método 3: Instalación desde el Panel de Archivos

1. **Acceder al panel de archivos**
   - Usa el administrador de archivos de tu hosting (cPanel, Plesk, etc.)
   - Navega a `/wp-content/plugins/`

2. **Subir y descomprimir**
   - Sube el archivo `bcv-exchange-rates.zip`
   - Descomprímelo en el servidor
   - Asegúrate de que la carpeta se llame `bcv-exchange-rates`

3. **Activar**
   - Ve al panel de WordPress
   - Activa el plugin desde **Plugins > Plugins instalados**

## ⚙️ Configuración Inicial

### 1. Verificar Instalación

Después de activar el plugin:

1. Ve a cualquier página o entrada
2. Agrega el shortcode `[bcv_rates]`
3. Actualiza y verifica que se muestren los tipos de cambio

### 2. Configurar WP-Cron (Importante)

El plugin depende de WP-Cron para las actualizaciones automáticas:

#### Verificar WP-Cron:
1. Instala el plugin "WP Crontrol" para verificar los cron jobs
2. Busca el evento `bcv_update_rates_event`
3. Asegúrate de que esté programado para ejecutarse cada hora

#### Si WP-Cron no funciona:
1. Agrega esta línea a tu `wp-config.php`:
   ```php
   define('DISABLE_WP_CRON', false);
   ```

2. Configura un cron job en tu servidor:
   ```bash
   */15 * * * * wget -q -O - https://tusitio.com/wp-cron.php?doing_wp_cron >/dev/null 2>&1
   ```

### 3. Configuración de Permisos

Asegúrate de que los archivos tengan los permisos correctos:

```bash
# Permisos recomendados
chmod 755 /wp-content/plugins/bcv-exchange-rates/
chmod 644 /wp-content/plugins/bcv-exchange-rates/*.php
chmod 644 /wp-content/plugins/bcv-exchange-rates/assets/css/*.css
```

## 🧪 Verificación de Instalación

### 1. Verificar Shortcode

Crea una nueva página de prueba:

1. Ve a **Páginas > Agregar nueva**
2. Agrega el shortcode: `[bcv_rates]`
3. Publica la página
4. Verifica que se muestren los tipos de cambio

### 2. Verificar Actualización

1. Espera una hora o fuerza la actualización:
   - Desactiva el plugin
   - Actívalo nuevamente
   - Verifica que los datos se hayan actualizado

### 3. Verificar Logs

Si hay problemas, revisa los logs:

1. Activa el modo debug en `wp-config.php`:
   ```php
   define('WP_DEBUG', true);
   define('WP_DEBUG_LOG', true);
   ```

2. Revisa el archivo `/wp-content/debug.log`

## 🛠️ Solución de Problemas de Instalación

### Error: "No se pudo instalar el plugin"

**Causas posibles:**
- Archivo ZIP corrupto
- Falta de espacio en el servidor
- Permisos insuficientes

**Soluciones:**
1. Descarga nuevamente el archivo ZIP
2. Verifica el espacio disponible en tu hosting
3. Ajusta los permisos de las carpetas a 755

### Error: "El plugin no se activa"

**Causas posibles:**
- Error de PHP
- Conflicto con otro plugin
- Versión de PHP incompatible

**Soluciones:**
1. Revisa los logs de PHP
2. Desactiva temporalmente otros plugins
3. Actualiza PHP a versión 7.2 o superior

### Error: "No se muestran los tipos de cambio"

**Causas posibles:**
- Problemas de conexión al BCV
- Shortcode mal escrito
- Conflicto con el tema

**Soluciones:**
1. Verifica que el shortcode esté bien escrito
2. Cambia temporalmente a un tema predeterminado
3. Revisa la configuración del firewall

### Error: "Los datos no se actualizan"

**Causas posibles:**
- WP-Cron deshabilitado
- Problemas de conexión
- Caché del servidor

**Soluciones:**
1. Verifica que WP-Cron esté habilitado
2. Limpia la caché del servidor
3. Configura un cron job manual

## 📋 Configuración del Servidor

### PHP Configuration

En tu archivo `php.ini`, asegúrate de tener:

```ini
max_execution_time = 300
max_input_time = 300
memory_limit = 256M
post_max_size = 32M
upload_max_filesize = 32M
allow_url_fopen = On
```

### WordPress Configuration

En `wp-config.php`, considera agregar:

```php
// Aumentar límite de memoria
define('WP_MEMORY_LIMIT', '256M');

// Desactivar caché durante desarrollo
// define('WP_CACHE', false);

// Activar logs de debug
// define('WP_DEBUG', true);
// define('WP_DEBUG_LOG', true);
// define('WP_DEBUG_DISPLAY', false);
```

## 🔐 Seguridad

### Recomendaciones de Seguridad

1. **Mantén actualizado** el plugin y WordPress
2. **Usa HTTPS** para proteger las transmisiones de datos
3. **Limita el acceso** al archivo `wp-config.php`
4. **Monitorea** los logs de acceso
5. **Haz backups** regulares

### Permisos de Archivos Recomendados

```bash
# Archivos PHP
find /wp-content/plugins/bcv-exchange-rates/ -name "*.php" -exec chmod 644 {} \;

# Archivos CSS
find /wp-content/plugins/bcv-exchange-rates/ -name "*.css" -exec chmod 644 {} \;

# Directorios
find /wp-content/plugins/bcv-exchange-rates/ -type d -exec chmod 755 {} \;

# Archivo principal
chmod 644 /wp-content/plugins/bcv-exchange-rates/bcv-exchange-rates.php
```

## 📞 Soporte Post-Instalación

### Recursos de Ayuda

1. **Documentación completa**: Lee el archivo `README.md`
2. **Ejemplos de uso**: Revisa `ejemplos-de-uso.html`
3. **Foros de WordPress**: Comunidad WordPress en español
4. **Soporte técnico**: Contacta al desarrollador del plugin

### Comunidad

- **GitHub**: Reporta problemas y sugiere mejoras
- **WordPress.org**: Foros de soporte en español
- **Grupos de Facebook**: Comunidades WordPress Venezuela

## ✅ Checklist de Instalación

- [ ] WordPress 5.0+ instalado
- [ ] PHP 7.2+ configurado
- [ ] Plugin descargado correctamente
- [ ] Archivos subidos al servidor
- [ ] Plugin activado en WordPress
- [ ] Shortcode funcionando
- [ ] WP-Cron verificado
- [ ] Actualización automática confirmada
- [ ] Diseño responsive verificado
- [ ] Seguridad configurada

## 🎉 ¡Listo!

Una vez completados estos pasos, tu plugin BCV Exchange Rates estará completamente funcional y actualizando los tipos de cambio automáticamente cada hora.

Para más información sobre el uso avanzado del plugin, consulta la documentación completa en el archivo `README.md`.