# Guía de Personalización - BCV Exchange Rates

## 🎨 Cómo Personalizar la Apariencia del Plugin

El plugin BCV Exchange Rates incluye un sistema completo de personalización que te permite modificar todos los aspectos visuales directamente desde el panel de administración de WordPress.

## 📍 Acceder al Personalizador

1. Inicia sesión en tu panel de WordPress
2. Ve al menú **BCV Exchange Rates** → **Personalizar**
3. Se abrirá el panel de personalización con vista previa en tiempo real

## 🎯 Opciones de Personalización Disponibles

### 🎨 **Colores**

**Color Principal**
- Color para títulos y elementos destacados
- Valor por defecto: `#2c3e50` (azul oscuro)

**Color de Acento**
- Color para bordes y elementos decorativos
- Valor por defecto: `#d4af37` (dorado)

**Color de Fondo**
- Color de fondo del contenedor principal
- Valor por defecto: `#faf9f7` (crema)

**Color de Superficie**
- Color de fondo para tarjetas y elementos flotantes
- Valor por defecto: `#ffffff` (blanco)

**Color de Texto**
- Color principal del texto
- Valor por defecto: `#2c3e50` (azul oscuro)

**Color de Texto Secundario**
- Color para texto secundario y descripciones
- Valor por defecto: `#7f8c8d` (gris)

### 📏 **Tipografía**

**Tamaño de Fuente Base**
- Tamaño base de fuente para el contenido
- Rango: 12px - 20px
- Valor por defecto: `16px`

**Tamaño de Fuente de Precios**
- Tamaño de fuente para los precios/tasas
- Rango: 16px - 32px
- Valor por defecto: `20px`

**Grosor de Fuente de Precios**
- Grosor de la fuente para los precios
- Opciones: Ligero (300), Normal (400), Medio (500), Semi-negrita (600), Negrita (700)
- Valor por defecto: `600`

**Altura de Línea**
- Altura de línea para mejorar la legibilidad
- Rango: 1.0 - 2.0
- Valor por defecto: `1.6`

### 📐 **Espaciado y Márgenes**

**Margen del Contenedor**
- Margen exterior del contenedor principal
- Rango: 0px - 50px
- Valor por defecto: `20px`

**Padding del Contenedor**
- Espaciado interno del contenedor
- Rango: 10px - 40px
- Valor por defecto: `20px`

**Radio de Borde**
- Redondez de las esquinas de los elementos
- Rango: 0px - 20px
- Valor por defecto: `12px`

**Intensidad de Sombra**
- Intensidad de las sombras de los elementos
- Rango: 0% - 50%
- Valor por defecto: `10%`

### 📊 **Ajustes de Tabla**

**Padding de Celdas**
- Espaciado interno de las celdas de la tabla
- Rango: 8px - 24px
- Valor por defecto: `12px`

**Grosor de Borde**
- Grosor del borde de las celdas
- Rango: 0px - 3px
- Valor por defecto: `1px`

**Efecto Hover**
- Intensidad del efecto al pasar el mouse sobre las filas
- Opciones: Ninguno, Ligero, Medio, Fuerte
- Valor por defecto: `Medio`

## 🛠️ Herramientas del Personalizador

### 👁️ **Vista Previa en Tiempo Real**
- Muestra los cambios instantáneamente
- Puedes ver cómo se verá tu sitio antes de guardar
- Actualización automática al cambiar cualquier valor

### 📱 **Vista Previa Responsive**
- Vista de escritorio (por defecto)
- Vista de tablet (768px)
- Vista de móvil (480px)
- Verifica que tu diseño se vea bien en todos los dispositivos

### 💾 **Gestión de Configuraciones**

#### **Exportar Configuraciones**
- Guarda tus ajustes personalizados como archivo JSON
- Útil para respaldar tu diseño o usar en otros sitios
- Archivo descargable: `bcv-customizer-settings.json`

#### **Importar Configuraciones**
- Carga configuraciones previamente guardadas
- Compatible con archivos JSON exportados del plugin
- Rápido método para aplicar diseños existentes

#### **Resetear a Valores por Defecto**
- Restaura todos los valores a su configuración original
- Útil si quieres empezar de nuevo
- Confirmación requerida antes de ejecutar

## ⌨️ **Atajos de Teclado**

- **Ctrl/Cmd + R**: Actualizar vista previa
- **Ctrl/Cmd + E**: Exportar configuraciones

## 💡 **Consejos de Uso**

### 🎯 **Para Principiantes**
1. Comienza ajustando solo los colores principales
2. Usa la vista previa para ver cómo se ven los cambios
3. No tengas miedo de experimentar - siempre puedes resetear

### 🎨 **Para Diseñadores**
1. Crea una paleta de colores coherente con tu sitio
2. Ajusta la tipografía para que coincida con tu marca
3. Usa el espaciado para mejorar la legibilidad
4. Exporta tu diseño para usarlo en otros proyectos

### 🔧 **Para Desarrolladores**
1. Los ajustes se guardan como opción de WordPress
2. Puedes acceder a las configuraciones mediante código
3. El CSS se genera dinámicamente y se cacha
4. Compatible con temas y plugins personalizados

## 🎨 **Ejemplos de Personalización**

### **Diseño Corporativo (Azul y Gris)**
```
Color Principal: #1e3a8a
Color de Acento: #6b7280
Color de Fondo: #f8fafc
Tamaño de Fuente de Precios: 24px
Grosor de Fuente: 600
```

### **Diseño Vibrante (Rojo y Amarillo)**
```
Color Principal: #dc2626
Color de Acento: #eab308
Color de Fondo: #fef3c7
Tamaño de Fuente de Precios: 28px
Grosor de Fuente: 700
```

### **Diseño Minimalista (Negro y Blanco)**
```
Color Principal: #000000
Color de Acento: #333333
Color de Fondo: #ffffff
Tamaño de Fuente de Precios: 18px
Grosor de Fuente: 500
```

## 🔒 **Seguridad y Rendimiento**

- **Seguridad**: Solo administradores pueden acceder al personalizador
- **Validación**: Todos los valores se sanitizan antes de guardarse
- **Rendimiento**: CSS generado se cacha para optimizar la carga
- **Respaldos**: Configuraciones se guardan en la base de datos de WordPress

## ❓ **Solución de Problemas**

### **Los cambios no se ven reflejados**
1. Asegúrate de hacer clic en "Guardar cambios"
2. Limpia la caché del navegador
3. Verifica que no haya conflictos con otros plugins

### **El color picker no funciona**
1. Verifica que JavaScript esté habilitado
2. Comprueba si hay errores en la consola del navegador
3. Intenta usar otro navegador

### **La vista previa no se actualiza**
1. Verifica que AJAX esté funcionando
2. Comprueba los logs de WordPress
3. Intenta desactivar temporalmente otros plugins

## 📚 **Recursos Adicionales**

- [Guía de Colores Web](https://developer.mozilla.org/es/docs/Web/CSS/color)
- [Tipografía Web](https://developer.mozilla.org/es/docs/Web/CSS/font)
- [Diseño Responsive](https://developer.mozilla.org/es/docs/Web/CSS/Media_Queries/Using_media_queries)

## 🆘 **Soporte**

Si encuentras problemas con el personalizador:
1. Revisa los logs de WordPress
2. Verifica la compatibilidad con tu tema
3. Contacta soporte técnico del plugin
4. Consulta la documentación completa en el archivo README.md

---

**¡Disfruta creando tu diseño único con BCV Exchange Rates!** 🎨✨