# BCV Exchange Rates Plugin

Un plugin de WordPress que muestra los tipos de cambio del Banco Central de Venezuela (BCV) mediante shortcodes con actualización automática cada hora.

## Características

- ✅ **Shortcode flexible**: `[bcv_rates]` con múltiples opciones de configuración
- ✅ **Actualización automática**: Los datos se actualizan cada hora automáticamente
- ✅ **Diseño moderno**: Estilo editorial contemporáneo con tipografía Playfair Display e Inter
- ✅ **Responsive**: Se adapta perfectamente a dispositivos móviles y tablets
- ✅ **Múltiples formatos**: Tabla, tarjetas, lista o moneda individual
- ✅ **Banderas de moneda**: Indicadores visuales para cada moneda
- ✅ **Caché inteligente**: Optimiza el rendimiento con almacenamiento en caché
- ✅ **Accesibilidad**: Cumple con estándares de accesibilidad web

## Instalación

### Método 1: Instalación directa
1. Descarga el plugin como archivo ZIP
2. En WordPress, ve a **Plugins > Agregar nuevo**
3. Haz clic en **Subir plugin**
4. Selecciona el archivo ZIP y haz clic en **Instalar ahora**
5. Activa el plugin

### Método 2: Instalación manual
1. Descomprime el archivo ZIP
2. Sube la carpeta `bcv-exchange-rates` a `/wp-content/plugins/`
3. Activa el plugin desde el panel de WordPress

## Uso del Shortcode

### Shortcode básico
```
[bcv_rates]
```

### Parámetros disponibles

| Parámetro | Valores | Descripción | Default |
|-----------|---------|-------------|---------|
| `currency` | `USD`, `EUR`, `CNY`, `TRY`, `RUB` | Muestra solo una moneda específica | (todas) |
| `format` | `table`, `cards`, `list` | Formato de visualización | `table` |
| `show_date` | `yes`, `no` | Muestra la fecha de actualización | `yes` |
| `show_flags` | `yes`, `no` | Muestra las banderas de moneda | `yes` |
| `theme` | `modern`, `classic`, `minimal` | Tema de estilo | `modern` |

### Ejemplos de uso

**Mostrar todas las monedas en formato tabla:**
```
[bcv_rates]
```

**Mostrar solo el dólar americano:**
```
[bcv_rates currency="USD"]
```

**Formato de tarjetas sin banderas:**
```
[bcv_rates format="cards" show_flags="no"]
```

**Tema clásico con formato lista:**
```
[bcv_rates format="list" theme="classic"]
```

## Función PHP

También puedes usar la función PHP directamente en tus plantillas:

```php
<?php
// Mostrar todas las monedas
echo bcv_get_exchange_rates();

// Mostrar solo el euro en formato tarjeta
echo bcv_get_exchange_rates('EUR', 'cards');

// Con argumentos adicionales
echo bcv_get_exchange_rates('', 'table', array(
    'show_date' => 'no',
    'show_flags' => 'yes',
    'theme' => 'minimal'
));
?>
```

## Monedas Disponibles

| Código | Moneda | Bandera |
|--------|--------|---------|
| USD | Dólar Americano | 🇺🇸 |
| EUR | Euro | 🇪🇺 |
| CNY | Yuan Chino | 🇨🇳 |
| TRY | Lira Turca | 🇹🇷 |
| RUB | Rublo Ruso | 🇷🇺 |

## Diseño y Estilos

El plugin incluye tres temas de estilo:

### Modern (Por defecto)
- Tipografía: Playfair Display (títulos) + Inter (contenido)
- Colores: Fondo crema (#faf9f7), texto oscuro (#2c3e50), acento dorado (#d4af37)
- Efectos: Sombras suaves, transiciones fluidas, hover effects

### Classic
- Diseño más tradicional con colores azulados
- Adecuado para sitios corporativos

### Minimal
- Diseño limpio con mínimos elementos decorativos
- Colores neutros y sombras sutiles

## Actualización de Datos

Los datos se actualizan automáticamente cada hora mediante:

1. **WP-Cron**: WordPress ejecuta la actualización automáticamente
2. **Caché**: Los datos se almacenan en caché para optimizar el rendimiento
3. **Manual**: Puedes forzar la actualización desactivando y volviendo a activar el plugin

## Compatibilidad

- **WordPress**: 5.0 o superior
- **PHP**: 7.2 o superior
- **Navegadores**: Todos los navegadores modernos (Chrome, Firefox, Safari, Edge)
- **Temas**: Compatible con la mayoría de temas WordPress

## Rendimiento

- ✅ **Caché inteligente**: Reduce las solicitudes al servidor del BCV
- ✅ **CSS optimizado**: Hojas de estilo minimizadas y eficientes
- ✅ **Código limpio**: Siguiendo las mejores prácticas de WordPress
- ✅ **Sin dependencias externas**: No requiere bibliotecas adicionales

## Personalización Avanzada

### CSS Personalizado
Puedes sobrescribir los estilos agregando CSS personalizado en tu tema:

```css
/* Personalizar colores */
.bcv-exchange-rates {
    --color-primary: #tu-color;
    --color-accent: #tu-color-acento;
}

/* Personalizar tipografía */
.bcv-exchange-rates {
    --font-primary: 'Tu Fuente', serif;
}
```

### Filtros y Acciones
El plugin incluye ganchos para desarrolladores avanzados:

```php
// Modificar los datos antes de mostrarlos
add_filter('bcv_rates_data', function($data) {
    // Tu código aquí
    return $data;
});

// Ejecutar código después de actualizar las tasas
add_action('bcv_rates_updated', function($rates) {
    // Tu código aquí
});
```

## Solución de Problemas

### Los tipos de cambio no se actualizan
1. Verifica que WP-Cron esté funcionando correctamente
2. Comprueba los logs de WordPress
3. Intenta desactivar y volver a activar el plugin

### El shortcode no funciona
1. Asegúrate de que el plugin esté activado
2. Verifica que no haya errores de sintaxis en el shortcode
3. Comprueba si hay conflictos con otros plugins

### Problemas de visualización
1. Limpia la caché del navegador
2. Verifica si tu tema está sobrescribiendo los estilos
3. Comprueba la consola del navegador por errores de JavaScript

## Soporte

Para reportar problemas o solicitar características adicionales:

1. Crea un issue en el repositorio del plugin
2. Proporciona información detallada sobre el problema
3. Incluye la versión de WordPress y PHP que estás usando

## Licencia

Este plugin está licenciado bajo GPL v2 o superior.

## Créditos

- Desarrollado para la comunidad WordPress venezolana
- Inspirado en el diseño editorial moderno
- Tipografías: Google Fonts (Playfair Display + Inter)

---

**Nota**: Este plugin utiliza los datos públicos del Banco Central de Venezuela (BCV). La precisión de los datos depende de la disponibilidad del sitio web del BCV.