/**
 * BCV Exchange Rates - Admin JavaScript
 * Funcionalidades del panel de administración
 */

(function($) {
    'use strict';

    // Esperar a que DOM esté listo
    $(document).ready(function() {
        
        // Forzar actualización de tipos de cambio
        $('#bcv-force-update').on('click', function() {
            const $button = $(this);
            const $result = $('#bcv-update-result');
            
            // Deshabilitar botón y mostrar loading
            $button.addClass('bcv-loading').prop('disabled', true);
            $result.hide();
            
            // Realizar petición AJAX
            $.ajax({
                url: bcvAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'bcv_force_update',
                    nonce: bcvAdmin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $result.removeClass('error').addClass('success')
                            .html('<p>' + response.message + '</p>')
                            .show();
                        
                        // Recargar la página después de 2 segundos
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    } else {
                        $result.removeClass('success').addClass('error')
                            .html('<p>' + response.message + '</p>')
                            .show();
                    }
                },
                error: function(xhr, status, error) {
                    $result.removeClass('success').addClass('error')
                        .html('<p>Error: ' + error + '</p>')
                        .show();
                },
                complete: function() {
                    // Rehabilitar botón y quitar loading
                    $button.removeClass('bcv-loading').prop('disabled', false);
                }
            });
        });
        
        // Limpiar caché
        $('#bcv-clear-cache').on('click', function() {
            const $button = $(this);
            const $result = $('#bcv-update-result');
            
            // Deshabilitar botón y mostrar loading
            $button.addClass('bcv-loading').prop('disabled', true);
            $result.hide();
            
            // Realizar petición AJAX
            $.ajax({
                url: bcvAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'bcv_clear_cache',
                    nonce: bcvAdmin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $result.removeClass('error').addClass('success')
                            .html('<p>' + response.message + '</p>')
                            .show();
                    } else {
                        $result.removeClass('success').addClass('error')
                            .html('<p>' + response.message + '</p>')
                            .show();
                    }
                },
                error: function(xhr, status, error) {
                    $result.removeClass('success').addClass('error')
                        .html('<p>Error: ' + error + '</p>')
                        .show();
                },
                complete: function() {
                    // Rehabilitar botón y quitar loading
                    $button.removeClass('bcv-loading').prop('disabled', false);
                    
                    // Ocultar mensaje después de 3 segundos
                    setTimeout(function() {
                        $result.fadeOut();
                    }, 3000);
                }
            });
        });
        
        // Probar conexión
        $('#bcv-test-connection').on('click', function() {
            const $button = $(this);
            
            // Deshabilitar botón y mostrar loading
            $button.addClass('bcv-loading').prop('disabled', true);
            
            // Realizar petición AJAX
            $.ajax({
                url: bcvAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'bcv_test_connection',
                    nonce: bcvAdmin.nonce
                },
                success: function(response) {
                    let message = '';
                    
                    if (response.success) {
                        message = '<div class="notice notice-success"><p>' + 
                                 response.message + '</p></div>';
                        
                        // Mostrar datos si están disponibles
                        if (response.data && response.data.rates) {
                            message += '<div class="bcv-test-results"><h4>Datos obtenidos:</h4><ul>';
                            $.each(response.data.rates, function(currency, rate) {
                                message += '<li><strong>' + currency + ':</strong> ' + 
                                         rate.toFixed(2) + ' Bs</li>';
                            });
                            message += '</ul></div>';
                        }
                    } else {
                        message = '<div class="notice notice-error"><p>' + 
                                 response.message + '</p></div>';
                    }
                    
                    // Mostrar resultado
                    if (!$('#bcv-test-results').length) {
                        $button.after('<div id="bcv-test-results"></div>');
                    }
                    
                    $('#bcv-test-results').html(message);
                },
                error: function(xhr, status, error) {
                    const message = '<div class="notice notice-error"><p>Error: ' + 
                                   error + '</p></div>';
                    
                    if (!$('#bcv-test-results').length) {
                        $button.after('<div id="bcv-test-results"></div>');
                    }
                    
                    $('#bcv-test-results').html(message);
                },
                complete: function() {
                    // Rehabilitar botón y quitar loading
                    $button.removeClass('bcv-loading').prop('disabled', false);
                }
            });
        });
        
        // Ver logs (placeholder)
        $('#bcv-view-logs').on('click', function() {
            alert('Función en desarrollo. Los logs se pueden ver en wp-content/debug.log si WP_DEBUG está activado.');
        });
        
        // Restablecer plugin (con confirmación)
        $('#bcv-reset-plugin').on('click', function() {
            const confirmed = confirm('¿Estás seguro de que quieres restablecer el plugin? Esto limpiará todos los datos y configuraciones.');
            
            if (confirmed) {
                // Aquí iría la lógica para restablecer el plugin
                alert('Función en desarrollo. Para restablecer, desactiva y vuelve a activar el plugin.');
            }
        });
        
        // Función para mostrar notificaciones
        function bcv_show_notification(message, type = 'success') {
            const notification = $('<div class="notice notice-' + type + ' is-dismissible"><p>' + message + '</p></div>');
            
            // Agregar al principio del contenedor
            $('.wrap').prepend(notification);
            
            // Auto-ocultar después de 5 segundos
            setTimeout(function() {
                notification.fadeOut(function() {
                    $(this).remove();
                });
            }, 5000);
            
            // Hacer dismissible
            notification.on('click', '.notice-dismiss', function() {
                notification.remove();
            });
        }
        
        // Monitorear estado del servicio (cada 5 minutos)
        let serviceCheckInterval;
        
        function bcv_check_service_status() {
            // Esta función podría hacer una llamada AJAX para verificar el estado
            // Por ahora, es un placeholder para futura implementación
        }
        
        // Iniciar monitoreo si estamos en la página principal del plugin
        if ($('.bcv-admin-container').length) {
            serviceCheckInterval = setInterval(bcv_check_service_status, 300000); // 5 minutos
        }
        
        // Limpiar intervalo al salir de la página
        $(window).on('beforeunload', function() {
            if (serviceCheckInterval) {
                clearInterval(serviceCheckInterval);
            }
        });
        
        // Atajos de teclado
        $(document).on('keydown', function(e) {
            // Ctrl/Cmd + U para forzar actualización
            if ((e.ctrlKey || e.metaKey) && e.key === 'u') {
                e.preventDefault();
                $('#bcv-force-update').trigger('click');
            }
            
            // Ctrl/Cmd + L para limpiar caché
            if ((e.ctrlKey || e.metaKey) && e.key === 'l') {
                e.preventDefault();
                $('#bcv-clear-cache').trigger('click');
            }
        });
        
        // Mejorar accesibilidad
        $('#bcv-force-update').attr('aria-label', 'Forzar actualización de tipos de cambio');
        $('#bcv-clear-cache').attr('aria-label', 'Limpiar caché del plugin');
        $('#bcv-test-connection').attr('aria-label', 'Probar conexión con BCV');
        
        // Agregar tooltips
        $('#bcv-force-update').attr('title', 'Ctrl+U');
        $('#bcv-clear-cache').attr('title', 'Ctrl+L');
        
        // Prevenir doble clic en botones de acción
        $('.button').on('dblclick', function(e) {
            e.preventDefault();
        });
        
        // Mostrar información de versión y actualización
        setTimeout(function() {
            const version = '1.0.0';
            const lastCheck = localStorage.getItem('bcv_last_version_check');
            const now = Date.now();
            
            // Verificar versión una vez al día
            if (!lastCheck || (now - parseInt(lastCheck)) > 86400000) {
                // Aquí podrías verificar si hay actualizaciones disponibles
                localStorage.setItem('bcv_last_version_check', now.toString());
            }
        }, 5000);
        
    });
    
})(jQuery);