/**
 * BCV Exchange Rates Customizer JavaScript
 * Funcionalidades del personalizador de estilos
 */

(function($) {
    'use strict';

    // Esperar a que DOM esté listo
    $(document).ready(function() {
        
        // Inicializar color pickers
        $('.bcv-color-picker').wpColorPicker({
            change: function(event, ui) {
                updatePreview();
            },
            clear: function() {
                updatePreview();
            }
        });
        
        // Actualizar vista previa en tiempo real
        function updatePreview() {
            const formData = $('#bcv-customizer-form').serialize();
            
            $.ajax({
                url: bcvCustomizer.ajax_url,
                type: 'POST',
                data: {
                    action: 'bcv_get_custom_css',
                    nonce: bcvCustomizer.nonce,
                    form_data: formData
                },
                success: function(response) {
                    if (response.success) {
                        // Aplicar CSS personalizado a la vista previa
                        let $style = $('#bcv-custom-preview-style');
                        if (!$style.length) {
                            $style = $('<style id="bcv-custom-preview-style"></style>');
                            $('head').append($style);
                        }
                        $style.html(response.css);
                    }
                }
            });
        }
        
        // Actualizar valores de rangos en tiempo real
        $('.bcv-range-slider').on('input', function() {
            const $this = $(this);
            const value = $this.val();
            const $valueDisplay = $this.next('.bcv-range-value');
            
            if ($valueDisplay.length) {
                const suffix = $this.attr('id') === 'bcv_line_height' ? '' : 'px';
                $valueDisplay.text(value + suffix);
            }
            
            // Actualizar vista previa
            updatePreview();
        });
        
        // Actualizar cuando cambian selects
        $('select', '#bcv-customizer-form').on('change', function() {
            updatePreview();
        });
        
        // Botón de actualizar vista previa
        $('#bcv-refresh-preview').on('click', function() {
            const $button = $(this);
            $button.addClass('bcv-loading').prop('disabled', true);
            
            updatePreview();
            
            setTimeout(function() {
                $button.removeClass('bcv-loading').prop('disabled', false);
            }, 500);
        });
        
        // Navegación entre secciones
        $('.bcv-customizer-nav-item').on('click', function(e) {
            e.preventDefault();
            
            const $this = $(this);
            const section = $this.data('section');
            
            // Actualizar navegación activa
            $('.bcv-customizer-nav-item').removeClass('active');
            $this.addClass('active');
            
            // Mostrar/ocultar secciones
            $('.bcv-customizer-section').hide();
            $('.bcv-customizer-section[data-section="' + section + '"]').show();
        });
        
        // Función para resetear a valores por defecto
        function resetToDefaults() {
            if (confirm('¿Estás seguro de que quieres restablecer todos los valores por defecto?')) {
                // Limpiar configuraciones guardadas
                $.ajax({
                    url: bcvCustomizer.ajax_url,
                    type: 'POST',
                    data: {
                        action: 'bcv_reset_customizer',
                        nonce: bcvCustomizer.nonce
                    },
                    success: function(response) {
                        if (response.success) {
                            location.reload();
                        }
                    }
                });
            }
        }
        
        // Función para importar/exportar configuraciones
        function exportSettings() {
            const settings = {};
            
            // Recopilar todos los valores del formulario
            $('#bcv-customizer-form').find('input, select').each(function() {
                const $this = $(this);
                const name = $this.attr('name');
                const value = $this.val();
                
                if (name && value) {
                    // Convertir notación de array a objeto
                    const matches = name.match(/bcv_customizer_settings\[(.*?)\]\[(.*?)\]/);
                    if (matches) {
                        const section = matches[1];
                        const key = matches[2];
                        
                        if (!settings[section]) {
                            settings[section] = {};
                        }
                        settings[section][key] = value;
                    }
                }
            });
            
            // Crear archivo de descarga
            const dataStr = JSON.stringify(settings, null, 2);
            const dataUri = 'data:application/json;charset=utf-8,'+ encodeURIComponent(dataStr);
            
            const exportFileDefaultName = 'bcv-customizer-settings.json';
            
            const linkElement = document.createElement('a');
            linkElement.setAttribute('href', dataUri);
            linkElement.setAttribute('download', exportFileDefaultName);
            linkElement.click();
        }
        
        function importSettings(file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                try {
                    const settings = JSON.parse(e.target.result);
                    
                    // Aplicar configuraciones importadas
                    $.each(settings, function(section, values) {
                        $.each(values, function(key, value) {
                            const inputName = 'bcv_customizer_settings[' + section + '][' + key + ']';
                            const $input = $('[name="' + inputName + '"]');
                            
                            if ($input.length) {
                                $input.val(value);
                                
                                // Actualizar vista previa
                                if ($input.hasClass('bcv-color-picker')) {
                                    $input.wpColorPicker('color', value);
                                } else if ($input.hasClass('bcv-range-slider')) {
                                    const $valueDisplay = $input.next('.bcv-range-value');
                                    if ($valueDisplay.length) {
                                        const suffix = $input.attr('id') === 'bcv_line_height' ? '' : 'px';
                                        $valueDisplay.text(value + suffix);
                                    }
                                }
                            }
                        });
                    });
                    
                    updatePreview();
                    alert('Configuraciones importadas correctamente.');
                    
                } catch (error) {
                    alert('Error al importar las configuraciones: ' + error.message);
                }
            };
            reader.readAsText(file);
        }
        
        // Botón de exportar
        $('#bcv-export-settings').on('click', function(e) {
            e.preventDefault();
            exportSettings();
        });
        
        // Botón de importar
        $('#bcv-import-settings').on('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                importSettings(file);
            }
        });
        
        // Botón de resetear
        $('#bcv-reset-settings').on('click', function(e) {
            e.preventDefault();
            resetToDefaults();
        });
        
        // Atajos de teclado
        $(document).on('keydown', function(e) {
            // Ctrl/Cmd + R para actualizar vista previa
            if ((e.ctrlKey || e.metaKey) && e.key === 'r') {
                e.preventDefault();
                $('#bcv-refresh-preview').trigger('click');
            }
            
            // Ctrl/Cmd + E para exportar
            if ((e.ctrlKey || e.metaKey) && e.key === 'e') {
                e.preventDefault();
                $('#bcv-export-settings').trigger('click');
            }
        });
        
        // Guardado automático (cada 30 segundos)
        let autoSaveInterval;
        
        function startAutoSave() {
            autoSaveInterval = setInterval(function() {
                // Solo guardar si hay cambios no guardados
                if ($('#bcv-customizer-form').data('changed')) {
                    $('#bcv-customizer-form').submit();
                }
            }, 30000);
        }
        
        function stopAutoSave() {
            if (autoSaveInterval) {
                clearInterval(autoSaveInterval);
            }
        }
        
        // Detectar cambios en el formulario
        $('#bcv-customizer-form').on('change input', 'input, select', function() {
            $('#bcv-customizer-form').data('changed', true);
        });
        
        // Iniciar guardado automático
        startAutoSave();
        
        // Detener guardado automático al salir de la página
        $(window).on('beforeunload', function() {
            stopAutoSave();
        });
        
        // Confirmar salida si hay cambios no guardados
        $(window).on('beforeunload', function() {
            if ($('#bcv-customizer-form').data('changed')) {
                return 'Tienes cambios no guardados. ¿Estás seguro de que quieres salir?';
            }
        });
        
        // Vista previa responsive
        $('#bcv-preview-device').on('change', function() {
            const device = $(this).val();
            const $preview = $('.bcv-preview-wrapper');
            
            $preview.removeClass('preview-desktop preview-tablet preview-mobile');
            $preview.addClass('preview-' + device);
        });
        
        // Inicializar vista previa
        updatePreview();
        
        // Tooltips para ayuda
        $('.bcv-customizer-control').each(function() {
            const $control = $(this);
            const $label = $control.find('label');
            const $description = $control.find('.description');
            
            if ($description.length) {
                $label.attr('title', $description.text());
            }
        });
        
        // Mejorar accesibilidad
        $('.bcv-range-slider').each(function() {
            const $slider = $(this);
            const min = $slider.attr('min');
            const max = $slider.attr('max');
            const value = $slider.val();
            
            $slider.attr('aria-valuemin', min);
            $slider.attr('aria-valuemax', max);
            $slider.attr('aria-valuenow', value);
        });
        
        // Animaciones suaves
        $('.bcv-customizer-section').on('show', function() {
            $(this).fadeIn(300);
        });
        
        // Prevenir doble envío del formulario
        $('#bcv-customizer-form').on('submit', function() {
            $(this).data('changed', false);
        });
        
    });
    
})(jQuery);