<?php
/**
 * BCV Exchange Rates Configuration
 * Archivo de configuración del plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

// Configuración del plugin
return array(
    
    // Información del plugin
    'plugin' => array(
        'name' => 'BCV Exchange Rates',
        'version' => '1.0.0',
        'author' => 'Alain Milian Marin',
        'url' => 'https://smartsites.es/',
        'text_domain' => 'bcv-exchange-rates',
    ),
    
    // Configuración de actualización
    'update' => array(
        'interval' => HOUR_IN_SECONDS, // Actualizar cada hora
        'timeout' => 30, // Timeout para solicitudes HTTP
        'retry_attempts' => 3, // Intentos de reintento
        'backup_data' => true, // Guardar respaldo de datos
    ),
    
    // Monedas soportadas
    'currencies' => array(
        'USD' => array(
            'name' => 'Dólar Americano',
            'flag' => 'us',
            'symbol' => '$',
            'position' => 'before',
        ),
        'EUR' => array(
            'name' => 'Euro',
            'flag' => 'eu',
            'symbol' => '€',
            'position' => 'before',
        ),
        'CNY' => array(
            'name' => 'Yuan Chino',
            'flag' => 'cn',
            'symbol' => '¥',
            'position' => 'before',
        ),
        'TRY' => array(
            'name' => 'Lira Turca',
            'flag' => 'tr',
            'symbol' => '₺',
            'position' => 'before',
        ),
        'RUB' => array(
            'name' => 'Rublo Ruso',
            'flag' => 'ru',
            'symbol' => '₽',
            'position' => 'after',
        ),
    ),
    
    // Configuración de visualización
    'display' => array(
        'default_format' => 'table',
        'default_theme' => 'modern',
        'show_flags' => true,
        'show_date' => true,
        'show_currency_name' => true,
        'number_format' => array(
            'decimals' => 2,
            'decimal_separator' => ',',
            'thousands_separator' => '.',
        ),
    ),
    
    // Configuración de caché
    'cache' => array(
        'transient_name' => 'bcv_exchange_rates_data',
        'backup_transient_name' => 'bcv_exchange_rates_backup',
        'duration' => HOUR_IN_SECONDS,
        'backup_duration' => DAY_IN_SECONDS,
    ),
    
    // Configuración de estilos
    'styles' => array(
        'google_fonts' => array(
            'Playfair Display' => array(400, 600, 700),
            'Inter' => array(300, 400, 500, 600),
        ),
        'css_variables' => array(
            'font-primary' => "'Playfair Display', serif",
            'font-secondary' => "'Inter', -apple-system, BlinkMacSystemFont, sans-serif",
            'color-bg' => '#faf9f7',
            'color-surface' => '#ffffff',
            'color-primary' => '#2c3e50',
            'color-secondary' => '#34495e',
            'color-accent' => '#d4af37',
            'color-muted' => '#7f8c8d',
            'color-border' => '#e8e6e3',
            'color-shadow' => 'rgba(44, 62, 80, 0.1)',
            'border-radius' => '12px',
            'transition' => 'all 0.3s cubic-bezier(0.4, 0, 0.2, 1)',
        ),
    ),
    
    // Configuración de accesibilidad
    'accessibility' => array(
        'aria_labels' => true,
        'keyboard_navigation' => true,
        'screen_reader_support' => true,
        'high_contrast' => false,
    ),
    
    // Configuración de internacionalización
    'i18n' => array(
        'default_language' => 'es_VE',
        'languages' => array(
            'es_VE' => 'Español (Venezuela)',
            'en_US' => 'English (United States)',
            'pt_BR' => 'Português (Brasil)',
        ),
        'date_format' => 'd/m/Y H:i',
        'timezone' => 'America/Caracas',
    ),
    
    // Configuración de desarrollo
    'dev' => array(
        'debug_mode' => false,
        'log_requests' => false,
        'use_sample_data' => false, // Cambiar a false en producción
        'sample_data' => array(
            'USD' => 243.11050000,
            'EUR' => 280.04870937,
            'CNY' => 34.20574620,
            'TRY' => 5.72783475,
            'RUB' => 3.07773768,
        ),
    ),
    
);