<?php
/**
 * BCV Exchange Rates Customizer AJAX Functions
 * Funciones AJAX para el personalizador
 */

if (!defined('ABSPATH')) {
    exit;
}

// Función AJAX para resetear personalizador
add_action('wp_ajax_bcv_reset_customizer', 'bcv_ajax_reset_customizer');

function bcv_ajax_reset_customizer() {
    check_ajax_referer('bcv_customizer_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_die(__('No tienes permisos suficientes.'));
    }
    
    delete_option('bcv_customizer_settings');
    
    wp_send_json(array(
        'success' => true,
        'message' => __('Configuraciones restablecidas correctamente.')
    ));
}

// Función AJAX para importar configuraciones
add_action('wp_ajax_bcv_import_customizer', 'bcv_ajax_import_customizer');

function bcv_ajax_import_customizer() {
    check_ajax_referer('bcv_customizer_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_die(__('No tienes permisos suficientes.'));
    }
    
    $settings = json_decode(file_get_contents('php://input'), true);
    
    if ($settings) {
        update_option('bcv_customizer_settings', $settings);
        wp_send_json(array(
            'success' => true,
            'message' => __('Configuraciones importadas correctamente.')
        ));
    } else {
        wp_send_json(array(
            'success' => false,
            'message' => __('Error al importar las configuraciones.')
        ));
    }
}

// Función AJAX para obtener configuraciones actuales
add_action('wp_ajax_bcv_get_customizer_settings', 'bcv_ajax_get_customizer_settings');

function bcv_ajax_get_customizer_settings() {
    check_ajax_referer('bcv_customizer_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_die(__('No tienes permisos suficientes.'));
    }
    
    $customizer = BCV_Customizer::get_instance();
    $settings = $customizer->get_settings();
    
    wp_send_json(array(
        'success' => true,
        'settings' => $settings
    ));
}