<?php
/**
 * BCV Exchange Rates Customizer
 * Sistema de personalización de estilos
 */

if (!defined('ABSPATH')) {
    exit;
}

class BCV_Customizer {
    
    private static $instance = null;
    private $option_name = 'bcv_customizer_settings';
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('admin_init', array($this, 'register_customizer_settings'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_custom_styles'), 99);
        add_action('admin_enqueue_scripts', array($this, 'enqueue_customizer_scripts'));
        
        // AJAX para previsualización
        add_action('wp_ajax_bcv_get_custom_css', array($this, 'ajax_get_custom_css'));
        add_action('wp_ajax_nopriv_bcv_get_custom_css', array($this, 'ajax_get_custom_css'));
    }
    

    
    /**
     * Página de personalización
     */
    public function customizer_page() {
        if (!current_user_can('manage_options')) {
            wp_die(__('No tienes permisos suficientes para acceder a esta página.'));
        }
        
        $settings = $this->get_settings();
        ?>
        <div class="wrap">
            <h1><?php _e('Personalizar Apariencia BCV Exchange Rates', 'bcv-exchange-rates'); ?></h1>
            
            <div class="bcv-customizer-container">
                <div class="bcv-customizer-sidebar">
                    <form method="post" action="options.php" id="bcv-customizer-form">
                        <?php
                        settings_fields('bcv_customizer_settings');
                        ?>
                        
                        <!-- Sección de Colores -->
                        <div class="bcv-customizer-section" data-section="colors">
                            <h2><?php _e('Colores', 'bcv-exchange-rates'); ?></h2>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_color_primary"><?php _e('Color Principal', 'bcv-exchange-rates'); ?></label>
                                <input type="color" id="bcv_color_primary" name="bcv_customizer_settings[colors][primary]" 
                                       value="<?php echo esc_attr($settings['colors']['primary']); ?>" class="bcv-color-picker">
                                <p class="description"><?php _e('Color principal para títulos y elementos destacados', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_color_accent"><?php _e('Color de Acento', 'bcv-exchange-rates'); ?></label>
                                <input type="color" id="bcv_color_accent" name="bcv_customizer_settings[colors][accent]" 
                                       value="<?php echo esc_attr($settings['colors']['accent']); ?>" class="bcv-color-picker">
                                <p class="description"><?php _e('Color de acento para bordes y elementos decorativos', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_color_background"><?php _e('Color de Fondo', 'bcv-exchange-rates'); ?></label>
                                <input type="color" id="bcv_color_background" name="bcv_customizer_settings[colors][background]" 
                                       value="<?php echo esc_attr($settings['colors']['background']); ?>" class="bcv-color-picker">
                                <p class="description"><?php _e('Color de fondo del contenedor', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_color_surface"><?php _e('Color de Superficie', 'bcv-exchange-rates'); ?></label>
                                <input type="color" id="bcv_color_surface" name="bcv_customizer_settings[colors][surface]" 
                                       value="<?php echo esc_attr($settings['colors']['surface']); ?>" class="bcv-color-picker">
                                <p class="description"><?php _e('Color de fondo para tarjetas y elementos flotantes', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_color_text"><?php _e('Color de Texto', 'bcv-exchange-rates'); ?></label>
                                <input type="color" id="bcv_color_text" name="bcv_customizer_settings[colors][text]" 
                                       value="<?php echo esc_attr($settings['colors']['text']); ?>" class="bcv-color-picker">
                                <p class="description"><?php _e('Color principal del texto', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_color_muted"><?php _e('Color de Texto Secundario', 'bcv-exchange-rates'); ?></label>
                                <input type="color" id="bcv_color_muted" name="bcv_customizer_settings[colors][muted]" 
                                       value="<?php echo esc_attr($settings['colors']['muted']); ?>" class="bcv-color-picker">
                                <p class="description"><?php _e('Color para texto secundario y descripciones', 'bcv-exchange-rates'); ?></p>
                            </div>
                        </div>
                        
                        <!-- Sección de Tipografía -->
                        <div class="bcv-customizer-section" data-section="typography">
                            <h2><?php _e('Tipografía', 'bcv-exchange-rates'); ?></h2>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_font_size_base"><?php _e('Tamaño de Fuente Base', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_font_size_base" name="bcv_customizer_settings[typography][font_size_base]" 
                                       min="12" max="20" value="<?php echo esc_attr($settings['typography']['font_size_base']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['typography']['font_size_base']); ?>px</span>
                                <p class="description"><?php _e('Tamaño base de fuente para el contenido', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_font_size_rates"><?php _e('Tamaño de Fuente de Precios', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_font_size_rates" name="bcv_customizer_settings[typography][font_size_rates]" 
                                       min="16" max="32" value="<?php echo esc_attr($settings['typography']['font_size_rates']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['typography']['font_size_rates']); ?>px</span>
                                <p class="description"><?php _e('Tamaño de fuente para los precios/tasas', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_font_weight_rates"><?php _e('Grosor de Fuente de Precios', 'bcv-exchange-rates'); ?></label>
                                <select id="bcv_font_weight_rates" name="bcv_customizer_settings[typography][font_weight_rates]">
                                    <option value="300" <?php selected($settings['typography']['font_weight_rates'], '300'); ?>>Ligero (300)</option>
                                    <option value="400" <?php selected($settings['typography']['font_weight_rates'], '400'); ?>>Normal (400)</option>
                                    <option value="500" <?php selected($settings['typography']['font_weight_rates'], '500'); ?>>Medio (500)</option>
                                    <option value="600" <?php selected($settings['typography']['font_weight_rates'], '600'); ?>>Semi-negrita (600)</option>
                                    <option value="700" <?php selected($settings['typography']['font_weight_rates'], '700'); ?>>Negrita (700)</option>
                                </select>
                                <p class="description"><?php _e('Grosor de la fuente para los precios', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_line_height"><?php _e('Altura de Línea', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_line_height" name="bcv_customizer_settings[typography][line_height]" 
                                       min="1" max="2" step="0.1" value="<?php echo esc_attr($settings['typography']['line_height']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['typography']['line_height']); ?></span>
                                <p class="description"><?php _e('Altura de línea para mejorar la legibilidad', 'bcv-exchange-rates'); ?></p>
                            </div>
                        </div>
                        
                        <!-- Sección de Espaciado -->
                        <div class="bcv-customizer-section" data-section="spacing">
                            <h2><?php _e('Espaciado y Márgenes', 'bcv-exchange-rates'); ?></h2>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_margin_container"><?php _e('Margen del Contenedor', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_margin_container" name="bcv_customizer_settings[spacing][margin_container]" 
                                       min="0" max="50" value="<?php echo esc_attr($settings['spacing']['margin_container']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['spacing']['margin_container']); ?>px</span>
                                <p class="description"><?php _e('Margen exterior del contenedor principal', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_padding_container"><?php _e('Padding del Contenedor', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_padding_container" name="bcv_customizer_settings[spacing][padding_container]" 
                                       min="10" max="40" value="<?php echo esc_attr($settings['spacing']['padding_container']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['spacing']['padding_container']); ?>px</span>
                                <p class="description"><?php _e('Espaciado interno del contenedor', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_border_radius"><?php _e('Radio de Borde', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_border_radius" name="bcv_customizer_settings[spacing][border_radius]" 
                                       min="0" max="20" value="<?php echo esc_attr($settings['spacing']['border_radius']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['spacing']['border_radius']); ?>px</span>
                                <p class="description"><?php _e('Redondez de las esquinas de los elementos', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_shadow_intensity"><?php _e('Intensidad de Sombra', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_shadow_intensity" name="bcv_customizer_settings[spacing][shadow_intensity]" 
                                       min="0" max="50" value="<?php echo esc_attr($settings['spacing']['shadow_intensity']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['spacing']['shadow_intensity']); ?>%</span>
                                <p class="description"><?php _e('Intensidad de las sombras de los elementos', 'bcv-exchange-rates'); ?></p>
                            </div>
                        </div>
                        
                        <!-- Sección de Tabla -->
                        <div class="bcv-customizer-section" data-section="table">
                            <h2><?php _e('Ajustes de Tabla', 'bcv-exchange-rates'); ?></h2>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_table_padding"><?php _e('Padding de Celdas', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_table_padding" name="bcv_customizer_settings[table][padding]" 
                                       min="8" max="24" value="<?php echo esc_attr($settings['table']['padding']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['table']['padding']); ?>px</span>
                                <p class="description"><?php _e('Espaciado interno de las celdas de la tabla', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_table_border_width"><?php _e('Grosor de Borde', 'bcv-exchange-rates'); ?></label>
                                <input type="range" id="bcv_table_border_width" name="bcv_customizer_settings[table][border_width]" 
                                       min="0" max="3" value="<?php echo esc_attr($settings['table']['border_width']); ?>" class="bcv-range-slider">
                                <span class="bcv-range-value"><?php echo esc_html($settings['table']['border_width']); ?>px</span>
                                <p class="description"><?php _e('Grosor del borde de las celdas', 'bcv-exchange-rates'); ?></p>
                            </div>
                            
                            <div class="bcv-customizer-control">
                                <label for="bcv_table_hover_effect"><?php _e('Efecto Hover', 'bcv-exchange-rates'); ?></label>
                                <select id="bcv_table_hover_effect" name="bcv_customizer_settings[table][hover_effect]">
                                    <option value="none" <?php selected($settings['table']['hover_effect'], 'none'); ?>>Ninguno</option>
                                    <option value="light" <?php selected($settings['table']['hover_effect'], 'light'); ?>>Ligero</option>
                                    <option value="medium" <?php selected($settings['table']['hover_effect'], 'medium'); ?>>Medio</option>
                                    <option value="strong" <?php selected($settings['table']['hover_effect'], 'strong'); ?>>Fuerte</option>
                                </select>
                                <p class="description"><?php _e('Intensidad del efecto al pasar el mouse sobre las filas', 'bcv-exchange-rates'); ?></p>
                            </div>
                        </div>
                        
                        <?php submit_button(); ?>
                    </form>
                </div>
                
                <!-- Vista previa -->
                <div class="bcv-customizer-preview">
                    <div class="bcv-preview-header">
                        <h2><?php _e('Vista Previa', 'bcv-exchange-rates'); ?></h2>
                        <button type="button" class="button button-secondary" id="bcv-refresh-preview">
                            <?php _e('Actualizar Vista Previa', 'bcv-exchange-rates'); ?>
                        </button>
                    </div>
                    <div class="bcv-preview-content">
                        <div class="bcv-preview-wrapper">
                            <div class="bcv-exchange-rates bcv-theme-custom">
                                <div class="bcv-last-updated">
                                    <span class="bcv-label">Actualizado:</span>
                                    <span class="bcv-date"><?php echo current_time('mysql'); ?></span>
                                </div>
                                <table class="bcv-rates-table">
                                    <thead>
                                        <tr>
                                            <th>Moneda</th>
                                            <th>Tasa BCV</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="bcv-currency">
                                                <span class="bcv-flag flag-us"></span>
                                                <span class="bcv-code">USD</span>
                                                <span class="bcv-name">Dólar Americano</span>
                                            </td>
                                            <td class="bcv-rate">243,11 Bs</td>
                                        </tr>
                                        <tr>
                                            <td class="bcv-currency">
                                                <span class="bcv-flag flag-eu"></span>
                                                <span class="bcv-code">EUR</span>
                                                <span class="bcv-name">Euro</span>
                                            </td>
                                            <td class="bcv-rate">280,05 Bs</td>
                                        </tr>
                                        <tr>
                                            <td class="bcv-currency">
                                                <span class="bcv-flag flag-cn"></span>
                                                <span class="bcv-code">CNY</span>
                                                <span class="bcv-name">Yuan Chino</span>
                                            </td>
                                            <td class="bcv-rate">34,21 Bs</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
    
    /**
     * Registrar configuraciones del personalizador
     */
    public function register_customizer_settings() {
        register_setting(
            'bcv_customizer_settings',
            $this->option_name,
            array($this, 'sanitize_customizer_settings')
        );
    }
    
    /**
     * Sanitizar configuraciones
     */
    public function sanitize_customizer_settings($input) {
        $sanitized = array();
        
        // Colores
        if (isset($input['colors'])) {
            $sanitized['colors'] = array();
            foreach ($input['colors'] as $key => $color) {
                $sanitized['colors'][$key] = sanitize_hex_color($color);
            }
        }
        
        // Tipografía
        if (isset($input['typography'])) {
            $sanitized['typography'] = array_map('absint', $input['typography']);
            // Line height es float
            if (isset($input['typography']['line_height'])) {
                $sanitized['typography']['line_height'] = floatval($input['typography']['line_height']);
            }
            // Font weight es string
            if (isset($input['typography']['font_weight_rates'])) {
                $sanitized['typography']['font_weight_rates'] = sanitize_text_field($input['typography']['font_weight_rates']);
            }
        }
        
        // Espaciado
        if (isset($input['spacing'])) {
            $sanitized['spacing'] = array_map('absint', $input['spacing']);
        }
        
        // Tabla
        if (isset($input['table'])) {
            $sanitized['table'] = array();
            $sanitized['table']['padding'] = absint($input['table']['padding']);
            $sanitized['table']['border_width'] = absint($input['table']['border_width']);
            $sanitized['table']['hover_effect'] = sanitize_text_field($input['table']['hover_effect']);
        }
        
        return $sanitized;
    }
    
    /**
     * Obtener configuraciones actuales
     */
    public function get_settings() {
        $defaults = array(
            'colors' => array(
                'primary' => '#2c3e50',
                'accent' => '#d4af37',
                'background' => '#faf9f7',
                'surface' => '#ffffff',
                'text' => '#2c3e50',
                'muted' => '#7f8c8d',
            ),
            'typography' => array(
                'font_size_base' => 16,
                'font_size_rates' => 20,
                'font_weight_rates' => '600',
                'line_height' => 1.6,
            ),
            'spacing' => array(
                'margin_container' => 20,
                'padding_container' => 20,
                'border_radius' => 12,
                'shadow_intensity' => 10,
            ),
            'table' => array(
                'padding' => 12,
                'border_width' => 1,
                'hover_effect' => 'medium',
            ),
        );
        
        $saved = get_option($this->option_name, array());
        return wp_parse_args($saved, $defaults);
    }
    
    /**
     * Generar CSS personalizado
     */
    public function generate_custom_css() {
        $settings = $this->get_settings();
        
        $css = "/* BCV Exchange Rates Custom Styles */\n";
        $css .= ".bcv-exchange-rates.bcv-theme-custom {\n";
        
        // Colores CSS personalizados
        $css .= "  --color-primary: " . $settings['colors']['primary'] . ";\n";
        $css .= "  --color-accent: " . $settings['colors']['accent'] . ";\n";
        $css .= "  --color-bg: " . $settings['colors']['background'] . ";\n";
        $css .= "  --color-surface: " . $settings['colors']['surface'] . ";\n";
        $css .= "  --color-primary: " . $settings['colors']['text'] . ";\n";
        $css .= "  --color-muted: " . $settings['colors']['muted'] . ";\n";
        
        // Tipografía
        $css .= "  font-size: " . $settings['typography']['font_size_base'] . "px;\n";
        $css .= "  line-height: " . $settings['typography']['line_height'] . ";\n";
        
        $css .= "}\n\n";
        
        // Estilos específicos
        $css .= ".bcv-exchange-rates.bcv-theme-custom .bcv-rate {\n";
        $css .= "  font-size: " . $settings['typography']['font_size_rates'] . "px;\n";
        $css .= "  font-weight: " . $settings['typography']['font_weight_rates'] . ";\n";
        $css .= "}\n\n";
        
        // Márgenes y espaciado
        $css .= ".bcv-exchange-rates.bcv-theme-custom {\n";
        $css .= "  margin: " . $settings['spacing']['margin_container'] . "px 0;\n";
        $css .= "  padding: " . $settings['spacing']['padding_container'] . "px;\n";
        $css .= "  border-radius: " . $settings['spacing']['border_radius'] . "px;\n";
        $css .= "}\n\n";
        
        // Tabla personalizada
        $css .= ".bcv-exchange-rates.bcv-theme-custom .bcv-rates-table th,\n";
        $css .= ".bcv-exchange-rates.bcv-theme-custom .bcv-rates-table td {\n";
        $css .= "  padding: " . $settings['table']['padding'] . "px;\n";
        $css .= "  border-width: " . $settings['table']['border_width'] . "px;\n";
        $css .= "}\n\n";
        
        // Sombra personalizada
        $shadow_intensity = $settings['spacing']['shadow_intensity'] / 100;
        $css .= ".bcv-exchange-rates.bcv-theme-custom .bcv-card,\n";
        $css .= ".bcv-exchange-rates.bcv-theme-custom .bcv-rates-table {\n";
        $css .= "  box-shadow: 0 4px " . (20 * $shadow_intensity) . "px rgba(44, 62, 80, " . (0.1 * $shadow_intensity) . ");\n";
        $css .= "}\n\n";
        
        return $css;
    }
    
    /**
     * Enqueue estilos personalizados
     */
    public function enqueue_custom_styles() {
        $css = $this->generate_custom_css();
        
        wp_add_inline_style(
            'bcv-exchange-rates-style',
            $css
        );
    }
    
    /**
     * Enqueue scripts del personalizador
     */
    public function enqueue_customizer_scripts($hook) {
        if ($hook !== 'bcv-exchange-rates_page_bcv-customizer') {
            return;
        }
        
        wp_enqueue_script(
            'bcv-customizer',
            plugins_url('assets/js/customizer.js', dirname(__FILE__)),
            array('jquery', 'wp-color-picker'),
            '1.0.0',
            true
        );
        
        wp_localize_script('bcv-customizer', 'bcvCustomizer', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('bcv_customizer_nonce'),
        ));
        
        wp_enqueue_style('wp-color-picker');
    }
    
    /**
     * AJAX para obtener CSS personalizado
     */
    public function ajax_get_custom_css() {
        check_ajax_referer('bcv_customizer_nonce', 'nonce');
        
        $css = $this->generate_custom_css();
        
        wp_send_json(array(
            'success' => true,
            'css' => $css
        ));
    }
}

// Inicializar personalizador
BCV_Customizer::get_instance();